<?php 

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 

global $conf;
if (!$conf->tresorerie->enabled) {
  accessforbidden();
}
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture-rec.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/discount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/invoice.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';


dol_include_once("/tresorerie/class/tresorerie.class.php");

$form        = new Form($db);
$formother   = new FormOther($db);
$userstatic  = new User($db);
$tresorerie  = new tresorerie($db);


$langs->loadLangs(array('bills', 'companies', 'compta', 'products', 'banks', 'main', 'withdrawals', 'loan'));
$modname = $langs->trans("tresorerie");

$arr_nbday = [1=>31,2=>28,3=>31,4=>30,5=>31,6=>30,7=>31,8=>31,9=>30,10=>31,11=>30,12=>31];

$action = GETPOST('action');
$element = GETPOST('element');
$srch_nbmonth = GETPOST('srch_nbmonth') ? (int)GETPOST('srch_nbmonth') : 12;
$srch_year = GETPOST('srch_year') ? GETPOST('srch_year') : date('Y');

    
/*-------------PDF-----------------*/
if ($action == "pdf") {
    global $conf, $langs, $mysoc;
    
    $Client = new Societe($db);

    require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
    require_once dol_buildpath('/tresorerie/pdf/pdf.lib.php');
  
    $pdf->SetMargins(7, 2, 7, false);
    $pdf->SetFooterMargin(15);
    $pdf->setPrintFooter(true);
    $pdf->SetAutoPageBreak(TRUE,18);

    $height=$pdf->getPageHeight();

    $pdf->SetFont('', '', 7, '', true);
    $pdf->AddPage('L');
    $margint = $pdf->getMargins()['top'];
    $marginb = $pdf->getMargins()['bottom'];
    $marginl = $pdf->getMargins()['left'];

    $pdf->SetTextColor(0, 0, 60);

    $default_font_size = 7;
    $pdf->SetFont('', 'B', $default_font_size);
    $posy   = $margint;
    $posx   = $pdf->page_largeur-$pdf->getMargins()['right']-100;

    $pdf->SetXY($marginl, $posy);

    if($payrollmodel != 'france'){
        $pdf->SetXY($marginl, $posy);

        $heightimg = 15;
        if ($mysoc && $mysoc->logo)
        {
            $logodir = $conf->mycompany->dir_output;
            if (empty($conf->global->MAIN_PDF_USE_LARGE_LOGO))
            {
                $logo = $logodir.'/logos/thumbs/'.$mysoc->logo_small;
            }
            else {
                $logo = $logodir.'/logos/'.$mysoc->logo;
            }
            
            if (is_readable($logo))
            {
                $height = pdf_getHeightForLogo($logo);
                $pdf->Image($logo, $marginl, $posy, 0, $heightimg); // width=0 (auto)
            }
            else
            {
                $pdf->SetTextColor(200, 0, 0);
                $pdf->SetFont('', 'B', $default_font_size - 2);
                $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorLogoFileNotFound", $logo), 0, 'L');
                $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
            }
        }
        else
        {
            $heightimg = 8;
            $text = $mysoc->name;
            $pdf->MultiCell(100, 4, $langs->convToOutputCharset($text), 0, 'L');
        }

        $posy = $margint + $heightimg + 2;

        $pdf->SetTextColor(0, 0, 60);
        $currentwate    = $conf->global->PAYROLLMOD_WATERMARK_IMG;
        if($currentwate){
            $bMargin = $pdf->getBreakMargin();
            $auto_page_break = $pdf->getAutoPageBreak();
            $pdf->SetAutoPageBreak(false, 0);
            $img_file = $conf->mycompany->dir_output.'/watermark/'.$currentwate;
            $pdf->SetAlpha(0.1);
            $pdf->Image($img_file, 35, 100, 140, '', '', '', '', false, 300, '', false, false, 0);
            $pdf->SetAlpha(1);
            $pdf->SetAutoPageBreak(true, $bMargin);
            $pdf->setPageMark();
        }
    }

    $pdf->SetFont('', '', $default_font_size + 3);

    $pdf->SetXY($posx, $posy);
    require_once dol_buildpath('/tresorerie/rapports_export.php');

    // echo $html;
    // die();
    $pdf->writeHTML($html, true, false, true, false, '');
    ob_start();
    $namemod=$langs->trans('tresorerie');
    $pdf->Output($namemod.'.pdf', 'I');
    //ob_end_clean();
    die();
}



if($action == "xsl"){
    $filename=$langs->trans("etat_tresorerie").".xls";
    require_once dol_buildpath('/tresorerie/rapports_exportxls.php');
    header("Content-Type: application/xls");
    header("Content-Disposition: attachment; filename=".$filename."");
    echo $html;
    die(); 
}





$morejs  = array();
llxHeader(array(), $modname,'','','','',$morejs,0,0);

print load_fiche_titre($modname);


$arr_mois = monthArray($langs,1);
$colspan = $srch_nbmonth;
print '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'?facid='.$facid.'" id="formtresorerie" >';
    print '<input type="hidden" name="srch_nbmonth" value="'.$srch_nbmonth.'">';
    print '<input type="hidden" name="srch_year" value="'.$srch_year.'">';
    print '<table width="100%">';
        print '<tr><td style="width:33%">';
        print $langs->trans('Year').': ';
        $formother->select_year($srch_year ? $srch_year : -1, 'srch_year', 1, 20, 5);
        print '</td>';
        print '<td align="center"  style="width:33%">';
            print '<input type="radio" id="typeshow_all" name="typeshow" value="1"><label for="typeshow_all"> '.$langs->trans("showall").' </label>';
            print '   <input type="radio" id="typeshow_elem" name="typeshow" value="1" checked><label for="typeshow_elem"> '.$langs->trans("showelem").' </label>';
        print '</td>';
        print '<td align="right"  style="width:33%">';
            print '<a class="tresorerie_bdf" href="'.dol_buildpath("/tresorerie/rapports.php?action=pdf&srch_year=".$srch_year."&srch_nbmonth=".$srch_nbmonth,2).'" target="_blank" class="btn-pdf"><i class="fas fa-file-pdf"></i></a>';

            print '<a class="tresorerie_xls" href="'.dol_buildpath("/tresorerie/rapports.php?action=xsl&srch_year=".$srch_year."&srch_nbmonth=".$srch_nbmonth,2).'" class="btn-excel"><i class="fas fa-file-excel"></i></a>';
            print '<div style="float:right;">'.$langs->trans("showof").': '.$tresorerie->select_nbmonth($srch_nbmonth, 'srch_nbmonth', 'maxwidth50imp valignmiddle').' '.$langs->trans('Months').'</div>';
        print '</td></tr>';
    print '</table>';
    print '<br>';
    print '<div id="EtatTresorerie" class="div-table-responsive">';
        if(empty($element) || $element == 'income'){
            print '<div id="revenus">';
                print '<table class="noborder">';
                    print '<input type="hidden" name="action" value="generer">';
                    print '<tr class="liste_titre">';
                        print '<td class="td_vert"></td>';
                        print '<td class="td_titre" align="center" style="">'.$langs->trans("Income").'</td>';
                        print '<td class="td_vert"></td>';
                        print '<td class="td_vert"></td>';
                        print '<td class="td_vert"><span class="show_revenus" onclick="show_revenus(this)" data-elem="revenus"><i class="fa fa-angle-double-up"></i></span></td>';
                        foreach ($arr_mois as $key => $value) {
                            $cls='';
                            $month_current = date('m');
                            if($key == $month_current && $srch_year == date('Y'))
                                $cls ='td_vert_curent';
                            print '<td class="td-amount liste_titre '.$cls.'" align="center" >';
                                print $value;
                            print '</td>';
                            if($key == $srch_nbmonth){
                                break;
                            }
                        }
                    print '</tr>';
                print '</table>';
                print '<table class="noborder revenus tab_lign_factcl">';
                    $sql = "SELECT s.nom as label, s.rowid as rowkey, sum(pf.amount) as amount_ttc, MONTH(p.datep) as month";
                    $sql .= " FROM ".MAIN_DB_PREFIX."societe as s";
                    $sql .= ", ".MAIN_DB_PREFIX."facture as f";
                    $sql .= ", ".MAIN_DB_PREFIX."paiement_facture as pf";
                    $sql .= ", ".MAIN_DB_PREFIX."paiement as p";
                    $sql .= " WHERE p.rowid = pf.fk_paiement";
                    $sql .= " AND pf.fk_facture = f.rowid";
                    $sql .= " AND f.fk_soc = s.rowid";
                    if (!empty($srch_year)){
                        $sql .= " AND YEAR(p.datep) =".$srch_year;
                    }
                    $sql .= " AND f.entity IN (".getEntity('invoice').")";
                    if ($socid) $sql .= " AND f.fk_soc = ".$socid;
                    $sql .= " GROUP BY label, rowkey";


                    print '<thead>';
                        print '<tr class="trclean"><td class="td_vert"><td class="td_vide"></td><td class="td_vide"></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';
                        print '<tr class="lign_total total_lign_factcl">';
                            print '<td class="td_vert"></td>';
                            print '<td class="td_vide"></td>';
                            print '<td class="td_grey"></td>';
                            print '<td class="td_label" title="'.$langs->trans('BillsCustomers').'"><b>'.$langs->trans('BillsCustomers').'</b></td>';
                            print '<td class="td_grey" data-label="lign_factcl"><span class="show_lign" onclick="showhide_lign(this)"><i class="fa fa-angle-double-down"></i></span> <input type="hidden" value="'.$sql.'" class="sql"><input type="hidden" value="vert" class="color"></td>';
                           
                            // if($result['data'] && count($result['data'])>0){
                            //     foreach ($result['data'] as $key => $value) {
                            //         $data[$value->socid][$value->month]['montant_ttc'] += (isset($value->amount_ttc) ? $value->amount_ttc : 0);
                            //         $data[$value->socid]['label'] = $value->name;
                            //         $total[$value->month] += (isset($value->amount_ttc) ? $value->amount_ttc : 0);
                            //     }
                            // }
                            dol_syslog("get customer invoices", LOG_DEBUG);
                            $sql .= ', month';
                            $result = $db->query($sql);
                            if ($result) {
                                $num = $db->num_rows($result);
                                $i = 0;
                                while ($i < $num)
                                {
                                    $objp = $db->fetch_object($result);
                                    $data2[$objp->socid][$objp->month]['montant_ttc'] += (isset($objp->amount_ttc) ? $objp->amount_ttc : 0);
                                    $data2[$objp->socid]['label'] = $objp->name;
                                    $total[$objp->month] += (isset($objp->amount_ttc) ? $objp->amount_ttc : 0);
                                    $i++;
                                }
                                $db->free($result);
                            } else {
                                dol_print_error($db);
                            }
                            foreach ($arr_mois as $key => $value) {
                                $cls='';
                                $month_current = date('m');
                                if($key == $month_current && $srch_year == date('Y'))
                                    $cls ='td_curent';
                                print '<td align="center" class="td-amount '.$cls.'" >';
                                   print price($total[$key]);
                                   $totalg[$key] += $total[$key];
                                print '</td>';
                                if($key == $srch_nbmonth)
                                    break;
                            }
                        print '</tr>';
                    print '</thead>';
                    print '<tbody>';
                    

                    print '</tbody>';
                print '</table>';
                print '<table class="noborder revenus tab_lign_dons">';
                    // print '<body class="tab_don">';
                    if (!empty($conf->don->enabled))
                    {   
                        $sql = "SELECT concat(p.societe,'-',p.firstname,'-', p.lastname) as rowkey, MONTH(p.datedon) as month, concat(p.societe,' ',p.firstname,' ', p.lastname) as label, date_format(p.datedon,'%Y-%m') as dm, sum(p.amount) as amount_ttc";
                        $sql .= " FROM ".MAIN_DB_PREFIX."don as p";
                        $sql .= " INNER JOIN ".MAIN_DB_PREFIX."payment_donation as pe ON pe.fk_donation = p.rowid";
                        $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."c_paiement as c ON pe.fk_typepayment = c.id";
                        $sql .= " WHERE p.entity IN (".getEntity('donation').")";
                        $sql .= " AND fk_statut >= 2";
                        if (!empty($srch_year))
                        $sql .= " AND YEAR(p.datedon) = '".$srch_year."'";
                        $sql .= " GROUP BY p.societe, p.firstname, p.lastname";

                        print '<thead>';
                            print '<tr class="trclean"><td class="td_vert"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_titre" align="center" style=""></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';
                            print '<tr class="lign_total total_lign_dons">';
                                print '<td class="td_vert"></td>';
                                print '<td class="td_vide"></td>';
                                print '<td class="td_grey"></td>';
                                print '<td class="td_label" title="'.$langs->trans('Donations').'"><b>'.$langs->trans('Donations').'</b></td>';
                                print '<td class="td_grey" data-label="lign_dons"><span class="show_lign" onclick="showhide_lign(this)"><i class="fa fa-angle-double-down"></i></span><input type="hidden" value="'.$sql.'" class="sql"><input type="hidden" value="vert" class="color"></td>';
                                

                                $sql .= ', month';
                                $result = $db->query($sql);
                                $subtotal_ht = 0;
                                $subtotal_ttc = 0;
                                if ($result)
                                {
                                    $numd = $db->num_rows($result);
                                    $i = 0;
                                    if ($numd)
                                    {
                                        while ($i < $numd)
                                        {
                                            $obj = $db->fetch_object($result);

                                            $total_ttc_don[$obj->month] += $obj->amount_ttc;
                                            $i++;
                                        }   
                                    }
                                }
                                foreach ($arr_mois as $key => $value) {
                                    $cls='';
                                    $month_current = date('m');
                                    if($key == $month_current && $srch_year == date('Y'))
                                        $cls ='td_curent';
                                    print '<td align="center" class="td-amount '.$cls.'">';
                                       print price($total_ttc_don[$key]);
                                       $totalg[$key] += $total_ttc_don[$key];
                                    print '</td>';
                                    if($key == $srch_nbmonth)
                                    break;
                                }
                            print '<tr>';
                        print '<thead>';

                        print '<tbody>';
                        print '</tbody>';
                            
                    print '</table>';
                }
                print '<table class="noborder revenus tab_lign_tvadepens">';

                    if($conf->tax->enabled){
                        $sql = "SELECT '".$langs->trans("VATCollected")."' as label, date_format(t.datev,'%Y-%m') as dm, MONTH(t.datev) as month, (-1)*sum(t.amount) as amount_ttc";
                        $sql .= " FROM ".MAIN_DB_PREFIX."tva as t";
                        $sql .= " WHERE amount < 0";
                        if (!empty($srch_year) )
                            $sql .= " AND YEAR(t.datev) =".$srch_year;

                        $sql .= " AND t.entity = ".$conf->entity;
                        $sql .= " GROUP BY label";
                        print '<thead>';
                            print '<tr class="trclean"><td class="td_vert"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_titre" align="center" style=""></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';

                            print '<tr class="lign_total total_lign_tvadepens">';
                                print '<td class="td_vert"></td>';
                                print '<td class="td_vide"></td>';
                                print '<td class="td_grey"></td>';
                                print '<td class="td_label" title="'.$langs->trans('VAT').'"><b>'.$langs->trans('VAT').'</b></td>';
                                print '<td class="td_grey" data-label="lign_tvadepens" ><span class="show_lign" onclick="showhide_lign(this)"><i class="fa fa-angle-double-down"></i></span><input type="hidden" value="'.$sql.'" class="sql"><input type="hidden" value="vert" class="color"></td>';

                                $sql .= ', month';
                                $result = $db->query($sql);
                                if ($result) {
                                    $num = $db->num_rows($result);
                                    $i = 0;
                                    if ($num) {
                                        while ($i < $num) {
                                            $obj = $db->fetch_object($result);
                                            $total_ttc_tva[$obj->month] += $obj->amount_ttc;

                                            $i++;
                                        }
                                    }
                                    $db->free($result);
                                }
                                foreach ($arr_mois as $key => $value) {
                                    $cls='';
                                    $month_current = date('m');
                                    if($key == $month_current && $srch_year == date('Y'))
                                        $cls ='td_curent';

                                    print '<td align="center" class="td-amount '.$cls.'">';
                                       print price($total_ttc_tva[$key]);
                                       $totalg[$key] += $total_ttc_tva[$key];
                                    print '</td>';
                                    if($key == $srch_nbmonth)
                                        break;
                                }
                            print '<tr>';
                        print '</thead>';
                        print '<tbody>';
                        print '</tbody>';

                    }

                    print '</table>';
                    print '<table class="noborder">';
                        print '<tbody>';

                            print '<tr class="trclean"><td class="td_vert"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_titre" align="center" style=""></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';
                            print '<tr class="liste_total">';
                                print '<td class="td_vert" style="border-bottom: 1px solid #e9eaed !important;"></td>';
                                print '<td class="td_label" style="border-bottom: 1px solid #e9eaed !important;">'.$langs->trans("Total").'</td>';
                                print '<td class="td_vert" style="border-bottom: 1px solid #e9eaed !important;"></td>';
                                print '<td class="td_vert" style="border-bottom: 1px solid #e9eaed !important;"></td>';
                                print '<td class="td_vert" style="border-bottom: 1px solid #e9eaed !important;"></td>';
                                foreach ($arr_mois as $key => $value) {
                                    $cls='';
                                    $month_current = date('m');
                                    if($key == $month_current && $srch_year == date('Y'))
                                        $cls ='td_curent';
                                    print '<td align="center" class="td-amount '.$cls.'">';
                                        print price($totalg[$key]);
                                    print '</td>';
                                    if($key == $srch_nbmonth)
                                        break;
                                }
                            print '</tr>';
                        print '<tbody>';
                    print '</table>';
            print '</div>';
        }
        print '<br>';
        if(empty($element) || $element == 'outcome'){
            print '<div id="depenses">';
                print '<table class="noborder">';
                    print '<input type="hidden" name="action" value="generer">';

                    print '<tr class="liste_titre">';
                        print '<td class="td_orang"></td>';
                        print '<td class="td_titre" align="center">'.$langs->trans("Outcome").'</td>';
                        print '<td class="td_orang"></td>';
                        print '<td class="td_orang"><span class="show_depenses" onclick="show_depenses(this)" data-elem="depenses"><i class="fa fa-angle-double-up"></i></span></td>';
                        foreach ($arr_mois as $key => $value) {
                            $cls='';
                            $month_current = date('m');
                            if($key == $month_current && $srch_year == date('Y'))
                                $cls ='td_orang_curent';
                            print '<td class="td-amount liste_titre '.$cls.'" align="center" >';
                                print $value;
                            print '</td>';
                            if($key == $srch_nbmonth)
                                break;
                        }
                    print '</tr>';
                print '</table>';
                print '<table class="noborder depenses tab_lign_factfourn">';

                    $sql = "SELECT s.nom as label, s.rowid as rowkey, sum(pf.amount) as amount_ttc, MONTH(p.datep) as month";
                    $sql .= " FROM ".MAIN_DB_PREFIX."paiementfourn as p";
                    $sql .= ", ".MAIN_DB_PREFIX."paiementfourn_facturefourn as pf";
                    $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."facture_fourn as f";
                    $sql .= " ON pf.fk_facturefourn = f.rowid";
                    $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s";
                    $sql .= " ON f.fk_soc = s.rowid";
                    $sql .= " WHERE p.rowid = pf.fk_paiementfourn ";

                    if (!empty($srch_year)){
                        $sql .= " AND YEAR(p.datep) =".$srch_year;
                    }
                    $sql .= " AND f.entity IN (".getEntity('invoice').")";
                    if ($socid) $sql .= " AND f.fk_soc = ".$socid;
                    $sql .= " GROUP BY label, rowkey";
                    $sql .= $db->order($sortfield, $sortorder);
                    dol_syslog("get customer invoices", LOG_DEBUG);

                    print '<thead>';
                        print '<tr class="trclean"><td class="td_orang"></td><td class="td_vide"></td><td class="td_vide"><td class="td_vide"></td><td class="td_titre" align="center" style=""></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';

                        print '<tr class="lign_total total_lign_factfourn">';

                            print '<td class="td_orang"></td>';
                            print '<td class="td_vide"></td>';
                            print '<td class="td_grey"></td>';
                            print '<td class="td_label" title="'.$langs->trans('SuppliersInvoices').'"><b>'.$langs->trans('SuppliersInvoices').'</b></td>';
                            print '<td class="td_grey" data-label="lign_factfourn" ><span class="show_lign" onclick="showhide_lign(this)"><i class="fa fa-angle-double-down"></i></span><input type="hidden" value="'.$sql.'" class="sql"><input type="hidden" value="orang" class="color"></td>';
                            
                            $sql .= ', month';
                            $result = $db->query($sql);
                            if ($result) {
                                $num = $db->num_rows($result);
                                $i = 0;
                                while ($i < $num)
                                {
                                    $objp = $db->fetch_object($result);
                                    $total_soc[$objp->month] += (isset($objp->amount_ttc) ? $objp->amount_ttc : 0);
                                    $i++;
                                }
                                $db->free($result);
                            } else {
                                dol_print_error($db);
                            }
                  
                            foreach ($arr_mois as $key => $value) {
                                $cls='';
                                $month_current = date('m');
                                if($key == $month_current && $srch_year == date('Y'))
                                    $cls ='td_curent';
                                print '<td align="center" class="td-amount '.$cls.'">';
                                   print price($total_soc[$key]);
                                   $totalg_depens[$key] += $total_soc[$key];
                                print '</td>';
                                if($key == $srch_nbmonth)
                                    break;
                            }

                        print '</tr>';
                    print '</thead>';
                    print '<tbody>';
                    print '</tbody>';
                print '</table>';

                print '<table class="noborder depenses tab_lign_chargesociales">';
                   
                    print '<thead>';

                        $sql = "SELECT cs.rowid as rowid, c.id, c.libelle as label, sum(p.amount) as amount_ttc, MONTH(p.datep) as month";
                        $sql .= " FROM ".MAIN_DB_PREFIX."c_chargesociales as c";
                        $sql .= ", ".MAIN_DB_PREFIX."chargesociales as cs";
                        $sql .= ", ".MAIN_DB_PREFIX."paiementcharge as p";
                        $sql .= " WHERE p.fk_charge = cs.rowid";
                        $sql .= " AND cs.fk_type = c.id";
                        $sql .= " AND c.deductible = 0";

                        if (!empty($srch_year)){
                            $sql .= " AND YEAR(p.datep) =".$srch_year;
                        }

                        $sql .= " AND cs.entity = ".$conf->entity;
                        $sql .= " GROUP BY c.libelle, c.id";

                        print '<tr class="trclean"><td class="td_orang"></td><td class="td_vide"></td><td class="td_vide"><td class="td_vide"></td><td class="td_titre" align="center" style=""></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';

                        print '<tr class="lign_total total_lign_chargesociales">';
                            print '<td class="td_orang"></td>';
                            print '<td class="td_vide"></td>';
                            print '<td class="td_grey"></td>';
                            print '<td class="td_label" title="'.$langs->trans("SocialContributionsNondeductibles").'"><b>'.$langs->trans("SocialContributionsNondeductibles").'</b></td>';
                            print '<td class="td_grey" data-label="lign_chargesociales" ><span class="show_lign" onclick="showhide_lign(this)"><i class="fa fa-angle-double-down"></i></span><input type="hidden" value="'.$sql.'" class="sql"><input type="hidden" value="orang" class="color"></td>';
                            
                            $sql .= ', month';
                            $result = $db->query($sql);
                            if ($result) {
                                $num = $db->num_rows($result);
                                $i = 0;
                                if ($num) {
                                    while ($i < $num) {
                                        $obj = $db->fetch_object($result);

                                        $total_ttc_charg2[$obj->month] += $obj->amount_ttc;
                                        $i++;
                                    }
                                }
                            }
                            foreach ($arr_mois as $key => $value) {
                                $cls='';
                                $month_current = date('m');
                                if($key == $month_current && $srch_year == date('Y'))
                                    $cls ='td_curent';
                                print '<td align="center" class="td-amount '.$cls.'">';
                                   print price($total_ttc_charg2[$key]);
                                   $totalg_depens[$key] += $total_ttc_charg2[$key];
                                print '</td>';
                                if($key == $srch_nbmonth)
                                    break;
                            }

                        print '</tr>';
                    print '<thead>';

                    print '<tbody>';
                    print '</tbody>';
                    
                print '</table>';

                print '<table class="noborder depenses tab_lign_chargesociales2">';
                    $sql = "SELECT cs.rowid as rowid, c.id, c.libelle as label, sum(p.amount) as amount_ttc, MONTH(p.datep) as month";
                    $sql .= " FROM ".MAIN_DB_PREFIX."c_chargesociales as c";
                    $sql .= ", ".MAIN_DB_PREFIX."chargesociales as cs";
                    $sql .= ", ".MAIN_DB_PREFIX."paiementcharge as p";
                    $sql .= " WHERE p.fk_charge = cs.rowid";
                    $sql .= " AND cs.fk_type = c.id";
                    $sql .= " AND c.deductible = 1";

                    if (!empty($srch_year)){
                        $sql .= " AND YEAR(p.datep) =".$srch_year;
                    }

                    $sql .= " AND cs.entity = ".$conf->entity;
                    $sql .= " GROUP BY c.libelle, c.id";
                    print '<thead>';
                        print '<tr class="trclean"><td class="td_orang"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_titre" align="center" style=""></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';
                        print '<tr class="lign_total total_lign_chargesociales2">';
                            print '<td class="td_orang"></td>';
                            print '<td class="td_vide"></td>';
                            print '<td class="td_grey"></td>';
                            print '<td class="td_label" title="'.$langs->trans("SocialContributionsDeductibles").'"><b>'.$langs->trans("SocialContributionsDeductibles").'</b></td>';
                            print '<td class="td_grey" data-label="lign_chargesociales2" ><span class="show_lign" onclick="showhide_lign(this)"><i class="fa fa-angle-double-down"></i></span><input type="hidden" value="'.$sql.'" class="sql"><input type="hidden" value="orang" class="color"></td>';

                            dol_syslog("get social contributions deductible=1", LOG_DEBUG);
                            
                            $sql .= ', month';
                            $result = $db->query($sql);
                            $subtotal_ht = 0;
                            $subtotal_ttc = 0;
                            if ($result) {
                                $num = $db->num_rows($result);
                                $i = 0;
                                if ($num) {
                                    while ($i < $num) {
                                        $obj = $db->fetch_object($result);
                                        $total_ttc_charg[$obj->month] += -$obj->amount_ttc;
                                        $i++;
                                    }
                                }
                            }
                            foreach ($arr_mois as $key => $value) {
                                $cls='';
                                $month_current = date('m');
                                if($key == $month_current && $srch_year == date('Y'))
                                    $cls ='td_curent';
                                print '<td align="center" class="td-amount '.$cls.'">';
                                   print price(-$total_ttc_charg[$key]);
                                   $totalg_depens[$key] += -$total_ttc_charg[$key];
                                print '</td>';
                                if($key == $srch_nbmonth)
                                    break;
                            }

                        print '</tr>';
                    print '</thead>';
                    print '<tbody>';
                    print '</tbody>';
                print '</table>';

                if (!empty($conf->salaries->enabled))
                {
                    print '<table  class="noborder depenses tab_lign_salaris">';
                        $sql = "SELECT u.rowid as rowkey, concat(p.label,' ',u.firstname,' ',u.lastname) as label, p.fk_user, MONTH(p.datep) as month, date_format(p.datep,'%Y-%m') as dm, sum(p.amount) as amount_ttc";
                        $sql .= " FROM ".MAIN_DB_PREFIX."payment_salary as p";
                        $sql .= " INNER JOIN ".MAIN_DB_PREFIX."user as u ON u.rowid=p.fk_user";
                        $sql .= " WHERE p.entity IN (".getEntity('payment_salary').")";
                        if (!empty($srch_year) )
                            $sql .= " AND YEAR(p.datep) = ".$srch_year;

                        $sql .= " GROUP BY u.rowid, p.label";
                        print '<thead>';
                            print '<tr class="trclean"><td class="td_orang"></td><td colspan="'.$colspan.'"></td></tr>';
                            print '<tr class="lign_total total_lign_salaris">';
                                print '<td class="td_orang"></td>';
                                print '<td class="td_vide"></td>';
                                print '<td class="td_grey"></td>';
                                print '<td class="td_label" title="'.$langs->trans("Salaries").'"><b>'.$langs->trans("Salaries").'</b></td>';
                                print '<td class="td_grey" data-label="lign_salaris" ><span class="show_lign" onclick="showhide_lign(this)"><i class="fa fa-angle-double-down"></i></span><input type="hidden" value="'.$sql.'" class="sql"><input type="hidden" value="orang" class="color"></td>';

                                $sql .= ', month';
                                $result = $db->query($sql);
                                if ($result)
                                {
                                    $num = $db->num_rows($result);
                                    $i = 0;
                                    if ($num)
                                    {
                                        while ($i < $num)
                                        {
                                            $obj = $db->fetch_object($result);

                                            $total_ttc_salair[$obj->month] -= $obj->amount_ttc;

                                            $i++;
                                        }
                                    }
                                }
                                 foreach ($arr_mois as $key => $value) {
                                    $cls='';
                                    $month_current = date('m');
                                    if($key == $month_current && $srch_year == date('Y'))
                                        $cls ='td_curent';
                                    print '<td align="center" class="td-amount '.$cls.'">';
                                       print price(-$total_ttc_salair[$key]);
                                       $totalg_depens[$key] += -$total_ttc_salair[$key];
                                    print '</td>';
                                    if($key == $srch_nbmonth)
                                        break;
                                }
                            print '</tr>';
                        print '</thead>';

                        print '<tbody>';
                        print '</tbody>';

                    print '</table>';

                }
                if (!empty($conf->expensereport->enabled))
                {
                    print '<table  class="noborder depenses tab_lign_expens">';
                        print '<thead>';
                            print '<tr class="trclean"><td class="td_orang"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_titre" align="center" style=""></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';
                            print '<tr class="lign_total total_lign_expens">';
                                print '<td class="td_orang"></td>';
                                print '<td class="td_vide"></td>';
                                print '<td class="td_grey"></td>';

                                $sql = "SELECT p.rowid , u.rowid as rowkey, p.ref, u.rowid as userid, concat (u.firstname, ' ', u.lastname) as label, date_format(pe.datep,'%Y-%m') as dm, sum(p.total_ht) as amount_ht, sum(p.total_ttc) as amount_ttc, MONTH(pe.datep) as month";
                                $sql .= " FROM ".MAIN_DB_PREFIX."expensereport as p";
                                $sql .= " INNER JOIN ".MAIN_DB_PREFIX."user as u ON u.rowid=p.fk_user_author";
                                $sql .= " INNER JOIN ".MAIN_DB_PREFIX."payment_expensereport as pe ON pe.fk_expensereport = p.rowid";
                                $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."c_paiement as c ON pe.fk_typepayment = c.id";
                                $sql .= " WHERE p.entity IN (".getEntity('expensereport').")";
                                $sql .= " AND p.fk_statut>=5";

                                if (!empty($srch_year) )
                                {
                                    $sql .= " AND YEAR(pe.datep) =".$srch_year;
                                }

                                $sql .= " GROUP BY u.rowid";
                                print '<td class="td_label" title="'.$langs->trans("ExpenseReport").'"><b>'.$langs->trans("ExpenseReport").'</b></td>';
                                print '<td class="td_grey" data-label="lign_expens"><span class="show_lign" onclick="showhide_lign(this)"><i class="fa fa-angle-double-down"></i></span><input type="hidden" value="'.$sql.'" class="sql"><input type="hidden" value="orang" class="color"></td>';


                                $sql .= ', month';
                                $result = $db->query($sql);
                                if ($result)
                                {
                                    $num = $db->num_rows($result);
                                    $i = 0;
                                    if($num > 1)
                                    if ($num)
                                    {
                                        while ($i < $num)
                                        {
                                            $obj = $db->fetch_object($result);

                                            $total_ht -= $obj->amount_ttc;
                                            $total_ttc_expens[$obj->month] -= $obj->amount_ttc;
                                            $subtotal_ht += $obj->amount_ttc;
                                            $subtotal_ttc += $obj->amount_ttc;

                                            $data_expens[$obj->rowid][$obj->month]['amount_ttc'] = -$obj->amount_ttc;
                                            $data_expens[$obj->rowid]['label'] = $obj->firstname." ".$obj->lastname;
                                            $data_expens[$obj->rowid]['userid'] = $obj->userid;
                                            $i++;
                                        }
                                    }
                                }
                                foreach ($arr_mois as $key => $value) {
                                    $cls='';
                                    $month_current = date('m');
                                    if($key == $month_current && $srch_year == date('Y'))
                                        $cls ='td_curent';
                                    print '<td align="center" class="td-amount '.$cls.'">';
                                       print price(-$total_ttc_expens[$key]);
                                       $totalg_depens[$key] += -$total_ttc_expens[$key];
                                    print '</td>';
                                    if($key == $srch_nbmonth)
                                        break;
                                }
                            print '</tr>';
                        print '</thead>';
                        print '<tbody>';
                        print '</tbody>';
                    print '</table>';

                }

                if (!empty($conf->global->ACCOUNTING_REPORTS_INCLUDE_VARPAY)){
                    print '<table class="noborder depenses tab_lign_varpay">';
                        print '<thead>';
                            $sql = "SELECT '".$langs->trans("Debit")."' as label, SUM(p.amount) AS amount_ttc, MONTH(p.datep) as month FROM ".MAIN_DB_PREFIX."payment_various as p";
                            $sql .= ' WHERE 1 = 1';
                            if (!empty($srch_year) )
                                $sql .= " AND YEAR(p.datep) =".$srch_year;

                            $sql .= ' GROUP BY p.sens';
                            $sql .= ' ORDER BY p.sens';
                            dol_syslog('get various payments', LOG_DEBUG);
                            print '<tr class="trclean"><td class="td_orang"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_titre" align="center" style=""></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';
                            print '<tr class="lign_total total_lign_varpay">';
                                print '<td class="td_orang"></td>';
                                print '<td class="td_vide"></td>';
                                print '<td class="td_grey"></td>';
                                print '<td class="td_label" title="'.$langs->trans("VariousPayment").'"><b>'.$langs->trans("VariousPayment").'</b></td>';
                                print '<td class="td_grey" data-label="lign_varpay"><span class="show_lign" onclick="showhide_lign(this)"><i class="fa fa-angle-double-down"></i></span><input type="hidden" value="'.$sql.'" class="sql"><input type="hidden" value="orang" class="color"></td>';

                                $sql .= ', month';
                                $result = $db->query($sql);
                                if ($result)
                                {
                                    // Debit
                                    $obj = $db->fetch_object($result);
                                    $num = $db->num_rows($result);
                                    $i = 0;
                                    if ($num)
                                    {
                                        while ($i < $num)
                                        {
                                            $total_ttc_varpay[$obj->month] -= $obj->amount_ttc;
                                            $i++;
                                        }
                                    }
                                }
                                foreach ($arr_mois as $key => $value) {
                                    $cls='';
                                    $month_current = date('m');
                                    if($key == $month_current && $srch_year == date('Y'))
                                        $cls ='td_curent';
                                    print '<td align="center" class="td-amount '.$cls.'">';
                                       print price(-$total_ttc_varpay[$key]);
                                       $totalg_depens[$key] += -$total_ttc_varpay[$key];
                                    print '</td>';
                                    if($key == $srch_nbmonth)
                                        break;
                                }
                            print '</tr>';
                        print '</thead>';
                        print '<tbody>';
                        print '</tbody>';
                    print '</table>';
                }


                if (!empty($conf->global->ACCOUNTING_REPORTS_INCLUDE_LOAN) && !empty($conf->loan->enabled)){
                    print '<table class="noborder depenses tab_lign_loan">';
                        print '<thead>';
                            print '<tr class="trclean"><td class="td_orang"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_titre" align="center" style=""></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';
                            print '<tr class="lign_total total_lign_loan">';
                                print '<td class="td_orang"></td>';
                                print '<td class="td_vide"></td>';
                                print '<td class="td_grey"></td>';
                                $sql = 'SELECT l.rowid as id, l.label AS label, SUM(p.amount_capital + p.amount_insurance + p.amount_interest) as amount_ttc, MONTH(p.datep) as month FROM '.MAIN_DB_PREFIX.'payment_loan as p';
                                $sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'loan AS l ON l.rowid = p.fk_loan';
                                $sql .= ' WHERE 1 = 1';

                                if (!empty($srch_year) )
                                    $sql .= " AND YEAR(p.datep) =".$srch_year;

                                $sql .= ' GROUP BY p.fk_loan ';
                                $sql .= ' ORDER BY p.fk_loan';
                                print '<td class="td_label" title="'.$langs->trans("PaymentLoan").'"><b>'.$langs->trans("PaymentLoan").'</b></td>';
                                print '<td class="td_grey" data-label="lign_loan"><span class="show_lign" onclick="showhide_lign(this)"><i class="fa fa-angle-double-down"></i></span><input type="hidden" value="'.$sql.'" class="sql"><input type="hidden" value="orang" class="color"></td>';


                                $sql .= ', month';
                                $result = $db->query($sql);
                                if ($result)
                                {
                                    $num = $db->num_rows($result);
                                    if ($num)
                                    {
                                        while ($obj = $db->fetch_object($result))
                                        {

                                            $total_ttc_loan[$obj->month] -= $obj->amount_ttc;

                                            $data_loan[$obj->rowid][$obj->month]['amount_ttc'] = -$obj->amount_ttc;
                                            $data_loan[$obj->rowid]['label'] = $obj->label;
                                            $data_loan[$obj->rowid]['id'] = $obj->id;
                                        }
                                    }
                                }
                                foreach ($arr_mois as $key => $value) {
                                    $cls='';
                                    $month_current = date('m');
                                    if($key == $month_current && $srch_year == date('Y'))
                                        $cls ='td_curent';
                                    print '<td align="center" class="td-amount '.$cls.'">';
                                       print price(-$total_ttc_loan[$key]);
                                       $totalg_depens[$key] += -$total_ttc_loan[$key];
                                    print '</td>';
                                    if($key == $srch_nbmonth)
                                        break;
                                }
                               
                            print '</tr>';
                         print '</thead>';
                        print '<tbody>';

                        print '</tbody>';
                    print '</table>';

                }



                if (!empty($conf->tax->enabled )){
                    print '<table class="noborder depenses tab_lign_tvapay">';

                        $sql = "SELECT '".$langs->trans("VATPaid")."' as label, date_format(t.datev,'%Y-%m') as dm, sum(t.amount) as amount_ttc, MONTH(t.datev) as month";
                        $sql .= " FROM ".MAIN_DB_PREFIX."tva as t";
                        $sql .= " WHERE amount > 0";
                        if (!empty($srch_year))
                            $sql .= " AND YEAR(t.datev) = ".$srch_year;
                        $sql .= " AND t.entity = ".$conf->entity;
                        $sql .= " GROUP BY dm";
                        print '<thead>';
                            print '<tr class="trclean"><td class="td_orang"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_titre" align="center" style=""></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';
                            print '<tr class="lign_total total_lign_tvapay">';
                                print '<td class="td_orang"></td>';
                                print '<td class="td_vide"></td>';
                                print '<td class="td_grey"></td>';
                                print '<td class="td_label" title="'.$langs->trans("VAT").'"><b>'.$langs->trans("VAT").'<b></td>';
                                print '<td class="td_grey" data-label="lign_tvapay"><span class="show_lign" onclick="showhide_lign(this)"><i class="fa fa-angle-double-down"></i></span><input type="hidden" value="'.$sql.'" class="sql"><input type="hidden" value="orang" class="color"></td>';

                                dol_syslog("get vat really paid", LOG_DEBUG);

                                $sql .= ', month';
                                $result = $db->query($sql);
                                if ($result) {
                                    $num = $db->num_rows($result);
                                    $i = 0;
                                    if ($num) {
                                        while ($i < $num) {
                                            $obj = $db->fetch_object($result);
                                            $total_ttc_tvapay[$obj->month] -= $obj->amount_ttc;
                                            $i++;
                                        }
                                    }
                                }
                                foreach ($arr_mois as $key => $value) {
                                    $cls='';
                                    $month_current = date('m');
                                    if($key == $month_current && $srch_year == date('Y'))
                                        $cls ='td_curent';
                                    print '<td align="center" class="td-amount '.$cls.'">';
                                       print price(-$total_ttc_tvapay[$key]);
                                       $totalg_depens[$key] += -$total_ttc_tvapay[$key];
                                    print '</td>';
                                    if($key == $srch_nbmonth)
                                        break;
                                }
                            print '</tr>';
                        print '</thead>';
                        print '<tbody>';
                        print '</tbody>';
                    print '</table>';

                }
                print '<table class="noborder">';
                    print '<tbody>';
                        print '<tr class="trclean"><td class="td_orang"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_titre" align="center" style=""></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';
                        print '<tr class="liste_total">';
                            print '<td class="td_orang" style="border-bottom: 1px solid #e9eaed !important;"></td>';
                            print '<td class="td_label" style="border-bottom: 1px solid #e9eaed !important;">'.$langs->trans("Total").'</td>';
                            print '<td class="td_orang" style="border-bottom: 1px solid #e9eaed !important;"></td>';
                            print '<td class="td_orang" style="border-bottom: 1px solid #e9eaed !important;"></td>';
                            print '<td class="td_orang" style="border-bottom: 1px solid #e9eaed !important;"></td>';
                            foreach ($arr_mois as $key => $value) {
                                $cls='';
                                $month_current = date('m');
                                if($key == $month_current && $srch_year == date('Y'))
                                    $cls ='td_curent';
                                print '<td align="center" class="td-amount '.$cls.'">';
                                    print price($totalg_depens[$key]);
                                print '</td>';
                                if($key == $srch_nbmonth)
                                    break;
                            }
                        print '</tr>';
                    print '</tbody>';
                print '</table>';
            print '</div>';
        }

        print '<table class="noborder tab_total_tresor" width="100%">';
            print '<tbody>';
                print '<tr class="trclean"><td class="td_vide"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_vide"></td><td class="td_titre" align="center" style=""></td><td class="td-amount" colspan="'.$colspan.'"></td></tr>';
                print '<tr class="liste_total">';

                    print '<td class="td_vide" style="background-color:#dadbdd !important;"></td>';

                    print '<td class="td_label" style="border-bottom: 1px solid #e9eaed !important;white-space: initial;">'.$langs->trans("Total_tresorerie").'</td>';
                    print '<td class="td_vide" style="background-color:#dadbdd !important;"></td>';
                    print '<td class="td_vide" style="background-color:#dadbdd !important;"></td>';
                    print '<td class="td_vide" style="background-color:#dadbdd !important;"></td>';
                    foreach ($arr_mois as $key => $value) {
                        $cls='';
                        $month_current = date('m');
                        if($key == $month_current && $srch_year == date('Y'))
                            $cls ='td_curent';
                        print '<td align="center" class="td-amount '.$cls.'">';
                            $numtotal = $totalg[$key]-$totalg_depens[$key];
                            print price($numtotal);
                        print '</td>';
                        if($key == $srch_nbmonth)
                            break;
                    }
                print '</tr>';
            print '</tbody>';
        print '</table>';
      
    print '</div>';


print '</form>';
