<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   tresorerie     Module tresorerie
 *  \brief      Example of a module descriptor.
 *				Such a file must be copied into htdocs/tresorerie/core/modules directory.
 *  \file       htdocs/tresorerie/core/modules/modtresorerie.class.php
 *  \ingroup    tresorerie
 *  \brief      Description and activation file for module tresorerie
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';

/**
 *  Description and activation class for module tresorerie
 */
class modTresorerie extends DolibarrModules
{
	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
        global $langs,$conf;

        $this->db = $db;

        $this->editor_name = 'Dolibarr Store';
		$this->editor_url = 'https://www.dolibarrstore.com';

		$this->numero = 940334081;
		$this->rights_class = 'tresorerie';

		$this->family = "DolibarrStore";
		$this->name = preg_replace('/^mod/i','',get_class($this));
		$this->description = "Module9403340810Desc";
		$this->version = '2.0';
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		$this->special = 0;
		$this->picto='tresorerie@tresorerie';
		$this->module_parts = array(
			'hooks' => array(), 
			'css' 	=> array('/tresorerie/css/tresorerie.css'),
			'js' 	=> array('/tresorerie/js/tresorerie.js.php'),
		);

		$this->dirs = array();

		$this->config_page_url = array('tresorerie_setup.php@tresorerie');

		// Dependencies
		$this->hidden = false;			// A condition to hide module
		$this->depends = array();		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->conflictwith = array();	// List of modules id this module is in conflict with
		$this->phpmin = array(5,0);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("tresorerie@tresorerie");

		// Constants
		$this->const = array();

        $this->tabs = array();

        // Dictionaries
	    if (! isset($conf->tresorerie->enabled))
        {
        	$conf->tresorerie=new stdClass();
        	$conf->tresorerie->enabled=0;
        }
		$this->dictionaries=array();
       

        // Boxes
        $this->boxes = array();			// List of boxes
		// Example:

		// Permissions
		$this->rights = array();		// Permission array used by this module
		$r=5;
		
		$this->rights[$r][0] = $this->numero+$r;	
		$this->rights[$r][1] = 'Consulter';	
		$this->rights[$r][2] = 'l';	
		$this->rights[$r][3] = 1; 					
		$this->rights[$r][4] = 'lire';
		$r++;


		$this->rights[$r][0] = $this->numero+$r;	
		$this->rights[$r][1] = 'export';	
		$this->rights[$r][2] = 'e';	
		$this->rights[$r][3] = 1; 					
		$this->rights[$r][4] = 'export';
		$r++;

		// Main menu entries
		$this->menu = array();			// List of menus to add
		$r=0;
		// Add here entries to declare new menus

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy',
			'type'=>'left',
			'titre'=>'tresorerie',
			'leftmenu'=>'tresorerie',
			'url'=>'/tresorerie/rapports.php',
			'langs'=>'tresorerie@tresorerie',
			'position'=>100,
			'enabled'=>'1',
			'perms'=>'$user->rights->tresorerie->lire',
			'target'=>'',
			'user'=>2);
		$r++;
		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy,fk_leftmenu=tresorerie',
			'type'=>'left',
			'titre'=>'Income',
			'url'=>'/tresorerie/rapports.php?element=income',
			'langs'=>'tresorerie@tresorerie',
			'position'=>101,
			'enabled'=>'1',
			'perms'=>'$user->rights->tresorerie->lire',
			'target'=>'',
			'user'=>2);
		$r++;
		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy,fk_leftmenu=tresorerie',
			'type'=>'left',
			'titre'=>'Outcome',
			'url'=>'/tresorerie/rapports.php?element=outcome',
			'langs'=>'tresorerie@tresorerie',
			'position'=>102,
			'enabled'=>'1',
			'perms'=>'$user->rights->tresorerie->lire',
			'target'=>'',
			'user'=>2);
		$r++;
		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy,fk_leftmenu=tresorerie',
			'type'=>'left',
			'titre'=>'graffs_tresor',
			'url'=>'/tresorerie/rapports_graffs.php?element=outcome',
			'langs'=>'tresorerie@tresorerie',
			'position'=>103,
			'enabled'=>'1',
			'perms'=>'$user->rights->tresorerie->lire',
			'target'=>'',
			'user'=>2);
		$r++;
	}

	/**
	 *		Function called when module is enabled.
	 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *		It also creates data directories
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function init($options='')
	{
		$sqlm = array();

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."ds_categorietresor` (
		  `rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY
		  ,`label` varchar(255) DEFAULT NULL
		  ,`type` varchar(255) DEFAULT NULL
		)";
		$resql = $this->db->query($sql);

		return $this->_init($sqlm, $options);
	}

	/**
	 *		Function called when module is disabled.
	 *      Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function remove($options='')
	{
		$sql = array();
		return $this->_remove($sql, $options);
	}

}
