	<?php
/* Copyright (C) 2001-2006	Rodolphe Quiedeville<rodolphe@quiedeville.org>
 * Copyright (C) 2004-2011	Laurent Destailleur <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012	Regis Houssin	   <regis.houssin@capnetworks.com>
 * Copyright (C) 2013		Cédric Salvador	 <csalvador@gpcsolutions.fr>
 * Copyright (C) 2013		Florian Henry		<florian.henry@open-concept.pro>
 * Copyright (C) 2015-2018	Charlene Benke		<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file	   /portofolio/list.php
 *	\ingroup	commercial portofolio management
 *	\brief	  List of customers
 */

// Dolibarr environment
$res=0;
if (! $res && file_exists("../main.inc.php")) 
	$res=@include("../main.inc.php");		// For root directory
if (! $res && file_exists("../../main.inc.php")) 
	$res=@include("../../main.inc.php");	// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formcompany.class.php';

dol_include_once('/portofolio/core/lib/portofolio.lib.php');


$langs->load("companies");
$langs->load("customers");
$langs->load("suppliers");
$langs->load("commercial");
$langs->load("bills");
$langs->load("portofolio@portofolio");

// Security check
$socid = GETPOST('socid', 'int');
if ($user->societe_id) $socid=$user->societe_id;
$result = restrictedArea($user, 'societe', $socid, '');



/*
 * view
 */

$userstatic =new User($db);

$help_url='EN:Module_Third_Parties|FR:Module_Tiers|ES:Empresas';
llxHeader('', $langs->trans("Portofolio"), $help_url);


// on récupère les commerciaux associés à des tiers
$sql = "SELECT DISTINCT u.rowid, u.lastname as nom, u.firstname as prenom";
$sql.= " FROM ".MAIN_DB_PREFIX."societe_commerciaux as sc";
$sql.= " , ".MAIN_DB_PREFIX."user as u";
$sql.= " WHERE u.rowid = sc.fk_user";
$sql.= " AND u.statut = 1";
$sql.= " GROUP BY sc.fk_user, u.lastname, u.firstname ";
$sql.= " ORDER BY u.lastname , u.firstname ";


//print $sql;
$result = $db->query($sql);
if ($result) {
	$num = $db->num_rows($result);

	$picto="portofolio@portofolio";
	print_fiche_titre($langs->trans("OutStandingBillbyCommercialDashboard"), '', $picto);

	dol_fiche_head();

	$i = 0;

	print_barre_liste(
					$langs->trans("ListOfCommercials"), $page, $_SERVER["PHP_SELF"],
					'', $sortfield, $sortorder, '', 0, $num, 'title_companies'
	);

	print '<table id="listtable" class="noborder" width="100%">';
	print "<thead>\n";
	print '<tr class="liste_titre">';
	print_liste_field_titre($langs->trans("Commercial"));
	// on récupère le mode de règlement des factures
	$sqlcode = "SELECT rowid, code, libelle FROM ".MAIN_DB_PREFIX."c_payment_term";
	$sqlcode.= " WHERE active=1 ORDER BY rowid";
	$resultreglt = $db->query($sqlcode);
	if ($resultreglt) {
		$nummodreglt = $db->num_rows($resultreglt);

		$j=0;
		while ($j < $nummodreglt) {
			$objrglt = $db->fetch_object($resultreglt);

			if ($langs->trans("PaymentConditionShort".$objrglt->code) != "PaymentConditionShort".$objrglt->code)
				print_liste_field_titre($langs->trans("PaymentConditionShort".$objrglt->code));
			else
				print_liste_field_titre($objrglt->libelle);

			$j++;
		}
	}

	print "</tr>\n";
	print "</thead>\n";

	print "<tbody>\n";
	$var=True;
	$idlist="";
	
	$i=0;
	while ($i < $num) {
		$obj = $db->fetch_object($result);
		$idlist.=$obj->rowid.",";
		$var=!$var;

		print "<tr ".$bc[$var].">";
		print '<td>';		
		$userstatic->fetch($obj->rowid);
		print $userstatic->getNomUrl(1);
		print '</td>';

		$resultreglt = $db->query($sqlcode);
		if ($resultreglt) {
			$nummodreglt = $db->num_rows($resultreglt);

			$j=0;
			while ($j < $nummodreglt) {
				print '<td>';
				$objrglt = $db->fetch_object($resultreglt);
				// la requete pour récupérer les factures impayé avec le code 
				$sqlfact = "SELECT f.rowid, f.facnumber, s.nom, f.fk_soc, f.datef, f.total_ttc, f.total";
				$sqlfact.= " FROM ".MAIN_DB_PREFIX."facture as f";
				$sqlfact.= " , ".MAIN_DB_PREFIX."societe as s";
				$sqlfact.= " , ".MAIN_DB_PREFIX."societe_commerciaux as sc";
				$sqlfact.= " WHERE sc.fk_soc = f.fk_soc";
				$sqlfact.= " AND s.rowid = f.fk_soc";
				$sqlfact.= " AND f.paye=0 AND f.fk_statut=1";
				$sqlfact.= " AND f.fk_cond_reglement=".$objrglt->rowid;
				$sqlfact.= " AND sc.fk_user=".$obj->rowid;
				$resultfact = $db->query($sqlfact);
				if ($resultfact) {
					$nbfact = $db->num_rows($resultfact);
					$k=0;
					$totfact=0;
					$tooltip="<table><tr><td>Fact</td><td>Client</td><td>Date</td><td>MntTot</td></tr>";
					while ($k < $nbfact) {
						$objfact = $db->fetch_object($resultfact);
						$tooltip.="<tr><td>".$objfact->facnumber."</td>";
						$tooltip.="<td>".$objfact->nom."</td>";
						$tooltip.="<td>".$objfact->datef."</td>";
						if ($conf->global->PORTOFOLIO_REPORT_IN_TTC =="1") {
							$tooltip.="<td>".price($objfact->total_ttc)."</td></tr>";
							$totfact+=$objfact->total_ttc;
						} else {
							$tooltip.="<td>".price($objfact->total)."</td></tr>";
							$totfact+=$objfact->total;
						}
						$k++;
					}
					$tooltip.="</table>";

				if ($nbfact > 0)
					print '<div class="classfortooltip" title="'.$tooltip.'">'.price($totfact)." (".$nbfact.")</div>";
				}
				print '</td>';
				$j++;
			}
		}
		print "</tr>\n";
		$i++;
	}
	print "</tbody>\n";
	print "<tfoot>";
	print "<tr class='liste_total'>";
	print "<th></th>";
	print "</tr>\n";
	print "</tfoot>";
	print "</table>\n";

	print "</form>\n";
	$db->free($result);

	$parameters=array('sql' => $sql);
	// Note that $action and $object may have been modified by hook
	$formconfirm=$hookmanager->executeHooks('printFieldListFooter', $parameters);	
} else
	dol_print_error($db);

llxFooter();
$db->close();