	<?php
/* Copyright (C) 2001-2006	Rodolphe Quiedeville<rodolphe@quiedeville.org>
 * Copyright (C) 2004-2011	Laurent Destailleur <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012	Regis Houssin	   <regis.houssin@capnetworks.com>
 * Copyright (C) 2013		Cédric Salvador	 <csalvador@gpcsolutions.fr>
 * Copyright (C) 2013		Florian Henry		<florian.henry@open-concept.pro>
 * Copyright (C) 2015-2018	Charlene Benke		<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file	   /portofolio/list.php
 *	\ingroup	commercial portofolio management
 *	\brief	  List of customers
 */

// Dolibarr environment
$res=0;
if (! $res && file_exists("../main.inc.php")) 
	$res=@include("../main.inc.php");		// For root directory
if (! $res && file_exists("../../main.inc.php")) 
	$res=@include("../../main.inc.php");	// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formcompany.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';

dol_include_once('/portofolio/core/lib/portofolio.lib.php');


$langs->load("companies");
$langs->load("customers");
$langs->load("suppliers");
$langs->load("commercial");
$langs->load("bills");
$langs->load("portofolio@portofolio");

// Security check
$socid = GETPOST('socid', 'int');
if ($user->societe_id) $socid=$user->societe_id;
$result = restrictedArea($user, 'societe', $socid, '');


/*
 * view
 */

$userstatic =new User($db);

$help_url='EN:Module_Portofolio|FR:Module_Portofolio|ES:Modulo_Portofolio';
llxHeader('', $langs->trans("Portofolio"), $help_url);

// récupération de la plage de date et du mode de regroupement
$termMode = $conf->global->PORTOFOLIO_SELECTERM_MODE;
$termduration = $conf->global->PORTOFOLIO_SELECTERM_DURATION;

// on détermine la date de fin selon le paramétrage
if ($termMode =='WEEK') {
	// on détermine le premier jours de la semaine
	$timedeb = mktime(0, 0, 0, date("m"), date("d"), date("Y")); // jours en cours

	$jourdate= date("w", $timedeb); // quel jour on est (lundi, mardi,...
	if ($jourdate==0)
		$timedeb = strtotime(date("Y-m-d", $timedeb) . " -6 days");		
	elseif ($jourdate > 1)
		$timedeb = strtotime(date("Y-m-d", $timedeb) . " -".($jourdate-1)." days");		
	$timefin = strtotime(date("Y-m-d", $timedeb) . " +".(($termduration*(7+1))-1)." days");		
}
if ($termMode =='MONTH') {
	$timedeb = mktime(0, 0, 0, date("m"), 1, date("Y")); // premier jour du mois 
	$timefin = strtotime(date("Y-m-d", $timedeb) . " +".($termduration+1)." months");
	$timefin = strtotime(date("Y-m-d", $timefin) . " -1 day");
}

// on récupère les commerciaux associés à des tiers
$sql = "SELECT DISTINCT u.rowid, u.lastname as nom, u.firstname as prenom";
$sql.= " FROM ".MAIN_DB_PREFIX."societe_commerciaux as sc";
$sql.= " , ".MAIN_DB_PREFIX."user as u";
$sql.= " WHERE u.rowid = sc.fk_user";
$sql.= " AND u.statut = 1";
$sql.= " GROUP BY sc.fk_user, u.lastname, u.firstname ";
$sql.= " ORDER BY u.lastname , u.firstname ";


//print $sql;
$result = $db->query($sql);
if ($result) {
	$num = $db->num_rows($result);

	$picto="portofolio@portofolio";
	print_fiche_titre($langs->trans("OrderbyCommercialDashboard"), '', $picto);

	dol_fiche_head();

	$i = 0;

	print_barre_liste(
					$langs->trans("ListOfCommercials"), $page, $_SERVER["PHP_SELF"],
					'', $sortfield, $sortorder, '', 0, $num, 'title_companies'
	);

	print '<table id="listtable" class="noborder" width="100%">';
	print "<thead>\n";
	print '<tr class="liste_titre">';
	print_liste_field_titre($langs->trans("Commercial"));
	
	// on boucle sur les colonnes
	for ($i=0; $i < (int) $termduration; $i++ ) {
		$datedebcol=$datedeb;
		if ($termMode =='WEEK') {
			$timedebcol = strtotime(date("Y-m-d", $timedeb) . "+".$i." weeks");
			//$timefincol = strtotime(date("Y-m-d", $timefin) . "+".$i." weeks");
			print_liste_field_titre(date("W-Y", $timedebcol ));

		}
		if ($termMode =='MONTH') {
			$timedebcol = strtotime(date("Y-m-d", $timedeb) . "+".$i." months");
			//$timefincol = strtotime(date("Y-m-d", $timedeb) . "+".($i+1)." months");
			//$timefincol = strtotime(date("Y-m-d", $timefincol) . "-1 day");
			print_liste_field_titre(date("m-Y", $timedebcol ));
		}
	}

	print "</tr>\n";
	print "</thead>\n";

	print "<tbody>\n";
	$var=true;
	$idlist="";
	
	$i=0;
	while ($i < $num) {
		$obj = $db->fetch_object($result);
		$idlist.=$obj->rowid.",";
		$var=!$var;

		print "<tr ".$bc[$var].">";
		print '<td>';		
		$userstatic->fetch($obj->rowid);
		print $userstatic->getNomUrl(1);
		print '</td>';

		// on boucle sur les colonnes
		for ($j=0; $j < (int) $termduration; $j++ ) {
			$datedebcol=$datedeb;
			if ($termMode =='WEEK') {
				$timedebcol = strtotime(date("Y-m-d", $timedeb) . "+".$j." weeks");
				$timefincol = strtotime(date("Y-m-d", $timedeb) . "+".($j+1)." weeks");
				$timefincol = strtotime(date("Y-m-d", $timefincol) . "-1 day");
			}
			if ($termMode =='MONTH') {
				$timedebcol = strtotime(date("Y-m-d", $timedeb) . "+".$j." months");
				$timefincol = strtotime(date("Y-m-d", $timedeb) . "+".($j+1)." months");
				$timefincol = strtotime(date("Y-m-d", $timefincol) . "-1 sec");
			}

			print '<td>';
			// la requete pour récupérer les commandes selon la plage de date
			$sqlcmde = "SELECT c.rowid, c.ref, s.nom, c.date_commande, c.date_livraison, c.total_ttc, c.total_ht";
			$sqlcmde.= " FROM ".MAIN_DB_PREFIX."commande as c";
			$sqlcmde.= " , ".MAIN_DB_PREFIX."societe as s";
			$sqlcmde.= " , ".MAIN_DB_PREFIX."societe_commerciaux as sc";
			$sqlcmde.= " WHERE sc.fk_soc = c.fk_soc";
			$sqlcmde.= " AND s.rowid = c.fk_soc";
			$sqlcmde.= " AND c.fk_statut=1";
			$sqlcmde.= " AND sc.fk_user=".$obj->rowid;
			
			if ($conf->global->PORTOFOLIO_FILTER_ON_ORDER_DATE =="1")
				$sqlcmde.= " AND c.date_commande";
			else
				$sqlcmde.= " AND c.date_livraison";

			$sqlcmde.= " between '".$db->idate($timedebcol)."' AND '".$db->idate($timefincol)."'";
			
			$resultcmde = $db->query($sqlcmde);
			if ($resultcmde) {
				$nbcmde = $db->num_rows($resultcmde);
				$k=0;
				$totcmde=0;
				$tooltip="";
				//$tooltip.=$sqlcmde."<br>";
				$tooltip.="<table class='noborder' width='100%'>";
				$tooltip.="<tr><td>Fact</td><td>Client</td><td>Date cmde</td><td>Date livr</td><td>MntTot</td>";
				$tooltip.="</tr>";

				while ($k < $nbcmde) {
					$objcmde = $db->fetch_object($resultfact);
					$tooltip.="<tr><td>".$objcmde->ref."</td>";
					
					$tooltip.="<td>".$objcmde->nom."</td>";
					$tooltip.="<td>".$objcmde->date_commande."</td>";
					$tooltip.="<td>".$objcmde->date_livraison."</td>";

					if ($conf->global->PORTOFOLIO_REPORT_IN_TTC =="1") {
						$tooltip.="<td>".price($objcmde->total_ttc)."</td>";
						$totcmde+= $objcmde->total_ttc;
					} else {
						$tooltip.="<td>".price($objcmde->total_ht)."</td>";
						$totcmde+= $objcmde->total_ht;
					}
					$tooltip.="</tr>";
					$k++;
				}
				$tooltip.="</table>";
				if ($nbcmde >0)
					print '<div class="classfortooltip" title="'.$tooltip.'">'.price($totcmde)." (".$nbcmde.")</div>";
				else
					print "000";
			}
			else {
				$tooltip=$sqlcmde;
				print '<div class="classfortooltip" title="'.$tooltip.'">X</div>';
			}
			print '</td>';
		}
		print "</tr>\n";
		$i++;
	}
	print "</tbody>\n";
//	print "<tfoot>";
//	print "<tr class='liste_total'>";
//	print "<th></th>";
//	print "</tr>\n";
//	print "</tfoot>";
	print "</table>\n";

	print "</form>\n";
	$db->free($result);

	$parameters=array('sql' => $sql);
	// Note that $action and $object may have been modified by hook
	$formconfirm=$hookmanager->executeHooks('printFieldListFooter', $parameters);	
} else
	dol_print_error($db);

llxFooter();
$db->close();